/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.cec;

import com.ibm.hsc.auiml.databeans.cec.HSCResRecoverBean;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.websm.lpar.DlparProcessorDialog;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import java.util.Hashtable;
import java.util.Vector;

public class HSCProcRecoverBean
extends HSCResRecoverBean {
    protected static final String CPU_INFO_DLPAR = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "CPU_INFO_DLPAR", "Any processors listed below may be available for adding, but are in an unusable state.  The processors may be in this state temporarily because of a DLPAR operation in progress.  Select \"Help\" for other reasons why processors may be in this state.  If you are sure that no dynamic reconfiguration is in progress, you may unassign processors by highlighting desired processors from the table below and selecting \"Unassign\".  The unassigned processors can then be added to the partition.");
    protected static final String CPU_INFO_ACTIVATE = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "CPU_INFO_ACTIVATE", "The partition cannot be activated because there are not enough free processors to satisfy the partition's minimum requirements. However, there are stopped processors available which are still assigned to running partitions.  Select \"Help\" for explanations as to how this might have happened.  If no DLPAR operations are in progress, you may unassign processors by highlighting the desired processors and then selecting \"Unassign\". The unassigned processors can then be used to activate the partition.");
    protected Vector mStoppedCPUIds = null;
    protected Vector mStoppedStatus = null;
    protected Vector mStoppedStates = null;
    protected String[] mProcColStr;
    protected ItemDescriptor[] mProcColId;
    protected String[] mStateColStr;
    protected ItemDescriptor[] mStateColId;
    protected String[] mStatusColStr;
    protected ItemDescriptor[] mStatusColId;

    public HSCProcRecoverBean() {
        this.mPanelName = "RecoverCpu";
        this.mAuimlClassName = "com.ibm.hsc.auiml.databeans.cec.ProcRecover";
    }

    protected void loadRecoverData(Hashtable hashtable) {
        this.mStoppedCPUIds = (Vector)hashtable.get("stoppedCpuIds");
        this.mStoppedStatus = (Vector)hashtable.get("stoppedCpuStatus");
        this.mStoppedStates = (Vector)hashtable.get("stoppedCpuStates");
        this.mParNames = (Vector)hashtable.get("stoppedCpuPartitionsUser");
        this.mParIntNames = (Vector)hashtable.get("stoppedCpuPartitionsInt");
    }

    private void loadBackendData() throws Exception {
        if (this.mParNames == null) {
            Hashtable hashtable = this.loadDataFromServer("getCpuRecoverInfo");
            this.loadRecoverData(hashtable);
        }
        int n = this.mParNames.size();
        this.mProcColId = new ItemDescriptor[n];
        this.mStateColId = new ItemDescriptor[n];
        this.mStatusColId = new ItemDescriptor[n];
        this.mParColId = new ItemDescriptor[n];
        int n2 = 0;
        while (n2 < this.mParNames.size()) {
            String string = (String)this.mParNames.elementAt(n2);
            String string2 = "" + this.mStoppedCPUIds.elementAt(n2);
            String string3 = "" + this.mStoppedStates.elementAt(n2);
            String string4 = "" + this.mStoppedStatus.elementAt(n2);
            this.mParColId[n2] = new ItemDescriptor("par" + n2, string);
            this.mProcColId[n2] = new ItemDescriptor("cpu" + n2, string2);
            this.mStateColId[n2] = new ItemDescriptor("ste" + n2, string3);
            this.mStatusColId[n2] = new ItemDescriptor("stu" + n2, string4);
            ++n2;
        }
    }

    protected boolean saveChanges() throws Exception {
        int n;
        int[] nArray = this.getRecoverTableSelection();
        Vector vector = new Vector();
        int n2 = 0;
        while (n2 < nArray.length) {
            n = nArray[n2];
            vector.addElement(this.mStoppedCPUIds.elementAt(n));
            ++n2;
        }
        n = 0;
        while (n < vector.size()) {
            System.out.println("sel cpu: " + vector.elementAt(n));
            ++n;
        }
        Object[] objectArray = new Object[]{vector};
        return this.saveDataToServer("recoverCpu", objectArray);
    }

    protected void showDLPARDialog() {
        if (this.mLparContainer != null) {
            DlparProcessorDialog.showDialog(this.mLparContainer);
        }
    }

    public void setProcColList(ItemDescriptor[] itemDescriptorArray) throws IllegalUserDataException {
        this.mProcColId = itemDescriptorArray;
    }

    public ItemDescriptor[] getProcColList() {
        return this.mProcColId;
    }

    public String[] getProcColSelection() {
        return this.mProcColStr;
    }

    public void setProcColSelection(String[] stringArray) throws IllegalUserDataException {
        this.mProcColStr = stringArray;
    }

    public void setStateColList(ItemDescriptor[] itemDescriptorArray) throws IllegalUserDataException {
        this.mStateColId = itemDescriptorArray;
    }

    public ItemDescriptor[] getStateColList() {
        return this.mStateColId;
    }

    public String[] getStateColSelection() {
        return this.mStateColStr;
    }

    public void setStateColSelection(String[] stringArray) throws IllegalUserDataException {
        this.mStateColStr = stringArray;
    }

    public void setStatusColList(ItemDescriptor[] itemDescriptorArray) throws IllegalUserDataException {
        this.mStatusColId = itemDescriptorArray;
    }

    public ItemDescriptor[] getStatusColList() {
        return this.mStatusColId;
    }

    public String[] getStatusColSelection() {
        return this.mStatusColStr;
    }

    public void setStatusColSelection(String[] stringArray) throws IllegalUserDataException {
        this.mStatusColStr = stringArray;
    }

    public void load() {
        block3: {
            try {
                this.mLoadException = null;
                super.load();
                this.mProcColStr = new String[0];
                this.mProcColId = new ItemDescriptor[0];
                this.mStateColStr = new String[0];
                this.mStateColId = new ItemDescriptor[0];
                this.mStatusColStr = new String[0];
                this.mStatusColId = new ItemDescriptor[0];
                this.loadBackendData();
                if (this.mFromActivate) {
                    this.mInfoArea = CPU_INFO_ACTIVATE;
                    break block3;
                }
                this.mInfoArea = CPU_INFO_DLPAR;
            }
            catch (Throwable throwable) {
                this.mLoadException = throwable;
                this.handleException(throwable, this.mActivateMsg);
            }
        }
    }
}

